﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ucEventEntry.ascx.cs" Inherits="ucEventEntry" %>
<script type="text/javascript">

    
    function AriaEventEntryBtn1(el) {
        el.set({
            "role": 'button'
        });
    }

    function AriaCancEEUCBtn(el) {
        el.set({
            "role": 'button'
        });
    }

    function AriaEEEditButton(el)
    {
        el.set({
            "role": 'button'
        });
    }

    function AriaEEDeleteButton(el)
    {
        el.set({
            "role": 'button'
        });
    }

    //hide edit options if entry does not belong to user logged in
    var UCEEPrepareCommand = function (grid, command, record, row) {
        if (command.command == 'CMD_UCEE_EDIT_ENTRY' && record.get('ALLOW_EDIT') < 1) {
            command.disabled = true;               
        }

        if (command.command == 'CMD_UCEE_DELETE_ENTRY' && record.get('ALLOW_EDIT') < 1) {
            command.disabled = true;               
        }

        if (command.command == 'CMD_UCEE_EDIT_ENTRY' && record.get('EVENT_STATUS') == 2) {
            command.disabled = true;                
        }

        if (command.command == 'CMD_UCEE_DELETE_ENTRY' && record.get('EVENT_STATUS') == 2) {
            command.disabled = true;              
        }

    };

    //grid panel command handlers for buttons in the grid 
    var OnUCEEEditCommand = function (command, strStoreRow) {
        switch (command) {
            case "CMD_UCEE_EDIT_ENTRY":
                App.direct.UCEVTENTRY.OnEditEntry(strStoreRow);
                break;

            case "CMD_UCEE_DELETE_ENTRY":
                if (confirm('Are You Sure You Want to Delete this Entry?')) {
                    App.direct.UCEVTENTRY.OnDeleteEntry(strStoreRow);
                }
                break;

        }
    }

 
    var fnEventEntryValForm = function () {
        if (App.dfUCEEDate.isValid() &&
           App.tfUCEEDate.isValid() &&
           App.tfUCEEComment.isValid()) {
            App.btnEventEntrySave.setDisabled(false);
        }
        else {
            App.btnEventEntrySave.setDisabled(true);
        }
    }
</script>

<ext:Window ID="wndUCEE"
    Title="Add/Edit Entry" Hidden="true"
    Layout="AnchorLayout" 
    Width="475"
    IDMode="Static" runat="server" 
    Constrain="true"
    ConstrainToElement="pnlMainWorkspace" 
    
    Modal="true"
    Collapsible="false"
    Resizable="false"
    Maximizable="false"
    Draggable="false" 
    XOnEsc="Ext.emptyFn">
    <Listeners>
    <Show Handler="Ext.defer(function() {App.dfUCEEDate.focus(true, 100);}, 1);" />
        <BeforeShow Handler="App.pnlMMenu.mask();App.vpMasterViewport.mask();"></BeforeShow>
        <Hide Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
        <Close Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
    </Listeners>
    <Items>

        <ext:Panel ID="fpnlUCEE"
            Margin="0"
            Padding="3"
            Border="false"
            runat="server"
            Visible="true"
            Layout="FormLayout" BodyPadding="4">
            <Items>

                <ext:DateField ID="dfUCEEDate" FieldLabel="Date"
                    runat="server"
                    AllowBlank="false"
                    AutoDataBind="true"
                    Width="200"
                    Format="MM/dd/yyyy"
                    Vtype="date"
                    InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                    <Listeners>
                        <Change Fn="fnEventEntryValForm" />
                    </Listeners>
                </ext:DateField>

                <ext:TimeField ID="tfUCEEDate" runat="server" Width="200"
                    Format="HH:mm"
                    MinTime="0:00"
                    MaxTime="23:59"
                    Increment="1"
                    FieldLabel="Time"
                    Vtype="time2">
                    <Listeners>
                        <Change Fn="fnEventEntryValForm" />
                    </Listeners>
                </ext:TimeField>

                <ext:ComboBox runat="server" ID="cboUCEEStatus" FieldLabel="Status"
                    Editable="false"
                    IDMode="Static"
                    ValueField="EVENT_STATUS_ID"
                    DisplayField="EVENT_STATUS">
                    <Store>
                        <ext:Store ID="storeUCEEStatus" AutoLoad="true" runat="server">
                            <Model>
                                <ext:Model ID="mdlUCEEStatus" runat="Server" IDProperty="EVENT_STATUS_ID">
                                    <Fields>
                                        <ext:ModelField Name="EVENT_STATUS_ID" />
                                        <ext:ModelField Name="EVENT_STATUS" />
                                    </Fields>
                                </ext:Model>
                            </Model>
                            <Reader>
                                <ext:JsonReader RootProperty="Tables[0].Rows">
                                </ext:JsonReader>
                            </Reader>
                        </ext:Store>
                    </Store>
                </ext:ComboBox>

                <ext:ComboBox runat="server" ID="cboUCEESeverity" FieldLabel="Functional Limitations"
                    Editable="false"
                    ValueField="EVENT_SEVERITY_ID"
                    DisplayField="EVENT_SEVERITY">
                    <Store>
                        <ext:Store ID="storeUCEESeverity" AutoLoad="true" runat="server">
                            <Model>
                                <ext:Model ID="mdlUCEESeverity" runat="Server" IDProperty="EVENT_SEVERITY_ID">
                                    <Fields>
                                        <ext:ModelField Name="EVENT_SEVERITY_ID" />
                                        <ext:ModelField Name="EVENT_SEVERITY" />
                                    </Fields>
                                </ext:Model>
                            </Model>
                            <Reader>
                                <ext:JsonReader RootProperty="Tables[0].Rows">
                                </ext:JsonReader>
                            </Reader>
                        </ext:Store>
                    </Store>

                </ext:ComboBox>

                <ext:ComboBox Visible="false" runat="server" ID="cboUCEETemplate" FieldLabel="Template"
                    Editable="false"
                    ValueField="TEMPLATE_ID"
                    DisplayField="DESCRIPTION">
                    <Store>
                        <ext:Store ID="storeUCEETemplates" AutoLoad="true" runat="server">
                            <Model>
                                <ext:Model ID="mdlUCEETemplate" runat="server" IDProperty="TEMPLATE_ID">
                                    <Fields>
                                        <ext:ModelField Name="TEMPLATE_ID" />
                                        <ext:ModelField Name="DESCRIPTION" />
                                    </Fields>
                                </ext:Model>
                            </Model>
                            <Reader>
                                <ext:JsonReader RootProperty="Tables[0].Rows">
                                </ext:JsonReader>
                            </Reader>
                        </ext:Store>
                    </Store>
                    <Listeners>
                        <Change Handler="App.direct.UCEVTENTRY.LoadTemplate(this.getValue());" />
                    </Listeners>
                </ext:ComboBox>

                <ext:TextArea runat="server" ID="tfUCEEComment"
                    FieldLabel="Comment" Vtype="alphanumXSS">
                    <Listeners>
                        <Change Fn="fnEventEntryValForm" />
                    </Listeners>
                </ext:TextArea>

            </Items>
        </ext:Panel>


    </Items>
    <BottomBar>
        <ext:Toolbar runat="server">
            <Items>
                <ext:Button ID="btnEventEntrySave" runat="server" Text="OK" Icon="Disk" Handler="App.direct.UCEVTENTRY.OnSave()" >
                <Listeners>
                    <AfterRender Handler="AriaEventEntryBtn1(App.btnEventEntrySave.getEl());" ></AfterRender>
                </Listeners>
                </ext:Button>

                <ext:Button ID="btnCancEEUC" runat="server" Text="Cancel" Icon="Cancel" Handler="App.direct.UCEVTENTRY.OnCancel()" >
                <Listeners>
                    <AfterRender Handler="AriaCancEEUCBtn(App.btnCancEEUC.getEl());" ></AfterRender>
                </Listeners>
                </ext:Button>

            </Items>
        </ext:Toolbar>
    </BottomBar>
</ext:Window>

<ext:GridPanel
    ID="gpUCEE"
    runat="server"
    Padding="0" 
    Border="false"
    Title="Entries"
    Layout="FitLayout"
    AnchorHorizontal="100%" 
    AnchorVertical="100%"
    ColumnLines="true"
    RowLines="true"
    AutoScroll="true" PaddingSpec="10 0 0 0" 
    Flex="1"
    Region="North"
    MaintainFlex="true">
    <Listeners>
    </Listeners>
    <SelectionModel>
        <ext:RowSelectionModel runat="server" Mode="Single">
            <Listeners>
                <Select Handler="App.direct.UCEVTENTRY.OnEntrySelect();"></Select>
            </Listeners>
            <CustomConfig>
            </CustomConfig>
        </ext:RowSelectionModel>
    </SelectionModel>
    <ColumnModel ID="cmdlUCEE" runat="server">
        <Columns>
            <ext:DateColumn ID="UCEEDate" runat="server"
                DataIndex="EVENT_DATE" Text="Date/Time" Format="Y-m-dd HH:i:s"
                Width="160" />
            <ext:Column ID="UCEEName" runat="server"
                DataIndex="USER_NAME" Text="Title/Name"
                Width="170" />
            <ext:Column ID="UCEEComment" runat="server"
                DataIndex="EVENT_COMMENT" Text="Note Entry"
                Flex="1" />

        </Columns>
    </ColumnModel>
    <Store>
        <ext:Store
            ID="storUCEEE"
            AutoLoad="true"
            runat="server">
            <Model>
                <ext:Model ID="mdlUCEE" runat="Server" IDProperty="PAT_PW_EVENT_ENTRY_ID">
                    <Fields>
                        <ext:ModelField Name="PAT_PW_EVENT_ENTRY_ID" />
                        <ext:ModelField Name="PATIENT_ID" />
                        <ext:ModelField Name="PAT_PW_ID" />
                        <ext:ModelField Name="PAT_PW_EVENT_ID" />
                        <ext:ModelField Name="EVENT_ENTRY_TYPE_ID" />
                        <ext:ModelField Name="EVENT_COMMENT" />
                        <ext:ModelField Name="FX_USER_ID" />
                        <ext:ModelField Name="EVENT_DATE" Type="Date" />
                        <ext:ModelField Name="EVENT_STATUS_ID" />
                        <ext:ModelField Name="EVENT_SEVERITY_ID" />
                        <ext:ModelField Name="PW_EVENT_MODULE_ID" />
                        <ext:ModelField Name="USER_NAME" />
                        <ext:ModelField Name="USER_TITLE" />
                        <ext:ModelField Name="EVENT_ENTRY_TYPE" />
                        <ext:ModelField Name="ALLOW_EDIT" />
                        <ext:ModelField Name="EVENT_STATUS" />
                        <ext:ModelField Name="MODULE" />
                    </Fields>
                </ext:Model>
            </Model>
            <Reader>
                <ext:JsonReader RootProperty="Tables[0].Rows">
                </ext:JsonReader>
            </Reader>
        </ext:Store>
    </Store>
     <BottomBar>
        <ext:Toolbar ID="tbucee" runat="server" TabIndex="35">
        <Items>
            <ext:Button ID="btuCEEdit" runat="server" Text="Edit Entry" Icon="PageWhiteEdit" >
                <Listeners>
                    <AfterRender Handler="AriaEEEditButton(App.btuCEEdit.getEl());" ></AfterRender>
                    <Click Handler="OnUCEEEditCommand('CMD_UCEE_EDIT_ENTRY', Ext.encode( #{gpUCEE}.getRowsValues({selectedOnly : true}) )) ;"></Click>
                </Listeners>
            </ext:Button>

            <ext:Button ID="btnuCEDelete" runat="server" Text="Delete Entry" Icon="Delete" >
                <Listeners>
                    <AfterRender Handler="AriaEEDeleteButton(App.btnuCEDelete.getEl());" ></AfterRender>
                    <Click Handler="OnUCEEEditCommand('CMD_UCEE_DELETE_ENTRY',   Ext.encode(#{gpUCEE}.getRowsValues({selectedOnly : true}) )) ;"></Click>
                </Listeners>
            </ext:Button>
        </Items>
    </ext:Toolbar>
    </BottomBar>
</ext:GridPanel>